*
* TRANSMISSION CONTROL BLOCK (TCB)
* FOR MARINA TCP MODULE - 29 DEC 15
*
*
* THESE ARE THE OFFSETS FOR EACH VARIABLE IN A TCB:
* NAMES ARE FROM RFC 793, PAGE 19
*
TCBSTATE EQU 0 ; TCP STATE
* SEND SEQUENCE VARIABLES
TCBSNDUNA EQU 1 ; SEND UNACKNOWLEDGED
TCBSNDNXT EQU 5 ; SEND NEXT
TCBSNDWND EQU 9 ; SEND WINDOW (16 BITS)
TCBSNDUP EQU 11 ; URGENT POINTER (16 BITS)
TCBSNDWL1 EQU 13 ; SEG SEQ FOR LAST WINDOW UPD
TCBSNDWL2 EQU 17 ; SEG ACK FOR ""   ""     ""
TCBISS EQU 21 ; INITIAL SEND SEQ NUMBER
* RECEIVE SEQUENCE VARIABLES
TCBRCVNXT EQU 25 ; RECEIVE NEXT
TCBRCVWND EQU 29 ; RECEIVE WINDOW (16 BITS)
TCBRCVUP EQU 33 ; RECEIVE URGENT POINTER (16 BITS)
TCBIRS EQU 35 ; INITIAL RECEIVE SEQ NUMBER
*
* TOTAL SIZES
*
TCBSIZE EQU 38 ; BYTES PER TCB
TCBTABSIZE EQU TCBSIZE*SOMAX
*
* THE TCB TABLE
*
TCBTAB DS TCBTABSIZE
